/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7145;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLChunkGenerator;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.jetbrains.annotations.NotNull;

public class LevelGenUtil {
    private static final String TAG_VERSION = "version";
    private static final String TAG_BN_GEN_VERSION = "generator_version";

    @NotNull
    public static class_5363 getBCLNetherLevelStem(WorldGenUtil.Context context, BCLNetherBiomeSourceConfig config) {
        BCLibNetherBiomeSource netherSource = new BCLibNetherBiomeSource(context.biomes, config);
        return new class_5363(context.dimension, (class_2794)new BCLChunkGenerator((class_2378<class_7059>)context.structureSets, (class_2378<class_5216.class_5487>)context.noiseParameters, netherSource, (class_6880<class_5284>)context.generatorSettings));
    }

    public static class_5363 getBCLEndLevelStem(WorldGenUtil.Context context, BCLEndBiomeSourceConfig config) {
        BCLibEndBiomeSource endSource = new BCLibEndBiomeSource(context.biomes, config);
        return new class_5363(context.dimension, (class_2794)new BCLChunkGenerator((class_2378<class_7059>)context.structureSets, (class_2378<class_5216.class_5487>)context.noiseParameters, endSource, (class_6880<class_5284>)context.generatorSettings));
    }

    public static class_5285 replaceGenerator(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_5455 registryAccess, class_5285 worldGenSettings, class_2794 generator) {
        class_2378 dimensionTypeRegistry = registryAccess.method_30530(class_2378.field_25095);
        class_2378<class_5363> newDimensions = LevelGenUtil.withDimension(dimensionKey, dimensionTypeKey, (class_2378<class_2874>)dimensionTypeRegistry, (class_2378<class_5363>)worldGenSettings.method_28609(), generator);
        return new class_5285(worldGenSettings.method_28028(), worldGenSettings.method_28029(), worldGenSettings.method_28030(), newDimensions);
    }

    public static class_2378<class_5363> withDimension(class_5321<class_5363> dimensionKey, class_5321<class_2874> dimensionTypeKey, class_2378<class_2874> dimensionTypeRegistry, class_2378<class_5363> inputDimensions, class_2794 generator) {
        class_5363 levelStem = (class_5363)inputDimensions.method_29107(dimensionKey);
        class_6880 dimensionType = levelStem == null ? dimensionTypeRegistry.method_44298(dimensionTypeKey) : levelStem.method_29566();
        return LevelGenUtil.withDimension(dimensionKey, inputDimensions, new class_5363(dimensionType, generator));
    }

    public static class_2378<class_5363> withDimension(class_5321<class_5363> dimensionKey, class_2378<class_5363> inputDimensions, class_5363 levelStem) {
        class_2370 writableRegistry = new class_2370(class_2378.field_25490, Lifecycle.experimental(), null);
        writableRegistry.method_10272(dimensionKey, (Object)levelStem, Lifecycle.stable());
        for (Map.Entry entry : inputDimensions.method_29722()) {
            class_5321 resourceKey = (class_5321)entry.getKey();
            if (resourceKey == dimensionKey) continue;
            writableRegistry.method_10272(resourceKey, (Object)((class_5363)entry.getValue()), inputDimensions.method_31139((Object)((class_5363)entry.getValue())));
        }
        return writableRegistry;
    }

    public static void migrateGeneratorSettings() {
        class_2487 settingsNbt = WorldGenUtil.getPresetsNbt();
        if (settingsNbt.method_10546() == 0) {
            class_2378<class_5363> dimensions;
            boolean isPre18;
            class_2487 oldGen = WorldGenUtil.getGeneratorNbt();
            if (oldGen != null && oldGen.method_10545("type")) {
                BCLib.LOGGER.info("Found World with beta generator Settings.");
                if ("bclib:bcl_world_preset_settings".equals(oldGen.method_10558("type"))) {
                    int netherVersion = 18;
                    int endVersion = 18;
                    if (oldGen.method_10545("minecraft:the_nether")) {
                        netherVersion = oldGen.method_10550("minecraft:the_nether");
                    }
                    if (oldGen.method_10545("minecraft:the_end")) {
                        endVersion = oldGen.method_10550("minecraft:the_end");
                    }
                    netherVersion = netherVersion == 18 ? 0 : (netherVersion == 17 ? 1 : 2);
                    endVersion = endVersion == 18 ? 0 : (endVersion == 17 ? 1 : 2);
                    List<Map<class_5321<class_5363>, class_2794>> presets = List.of(TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD), TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD_17), TogetherWorldPreset.getDimensionsMap((class_5321<class_7145>)class_5317.field_25050));
                    HashMap<class_5321<class_5363>, class_2794> dimensions2 = new HashMap<class_5321<class_5363>, class_2794>();
                    dimensions2.put(class_5363.field_25412, presets.get(0).get(class_5363.field_25412));
                    dimensions2.put(class_5363.field_25413, presets.get(netherVersion).get(class_5363.field_25413));
                    dimensions2.put(class_5363.field_25414, presets.get(endVersion).get(class_5363.field_25414));
                    TogetherWorldPreset.writeWorldPresetSettingsDirect(dimensions2);
                }
                return;
            }
            BCLib.LOGGER.info("Found World without generator Settings. Setting up data...");
            class_5321<class_7145> biomeSourceVersion = PresetsRegistry.BCL_WORLD;
            class_2487 bclRoot = WorldConfig.getRootTag("bclib");
            String bclVersion = "0.0.0";
            if (bclRoot.method_10545(TAG_VERSION)) {
                bclVersion = bclRoot.method_10558(TAG_VERSION);
            }
            boolean bl = isPre18 = !ModUtil.isLargerOrEqualVersion(bclVersion, "1.0.0");
            if (isPre18) {
                BCLib.LOGGER.info("World was create pre 1.18!");
                biomeSourceVersion = PresetsRegistry.BCL_WORLD_17;
            }
            if (WorldConfig.hasMod("betternether")) {
                BCLib.LOGGER.info("Found Data from BetterNether, using for migration.");
                class_2487 bnRoot = WorldConfig.getRootTag("betternether");
                class_5321<class_7145> class_53212 = biomeSourceVersion = "1.17".equals(bnRoot.method_10558(TAG_BN_GEN_VERSION)) ? PresetsRegistry.BCL_WORLD_17 : PresetsRegistry.BCL_WORLD;
            }
            if ((dimensions = TogetherWorldPreset.getDimensions(biomeSourceVersion)) != null) {
                BCLib.LOGGER.info("Set world to BiomeSource Version " + biomeSourceVersion);
                TogetherWorldPreset.writeWorldPresetSettings(dimensions);
            } else {
                BCLib.LOGGER.error("Failed to set world to BiomeSource Version " + biomeSourceVersion);
            }
        }
    }
}

